/*
 * Copyright European Commission's
 * Taxation and Customs Union Directorate-General (DG TAXUD).
 */
package eu.europa.ec.taxud.cesop.domain;

import java.util.ArrayList;
import java.util.List;

import lombok.Getter;

@Getter
public class XmlPsp {

    private final XmlTypeAndValue pspId;
    private final List<XmlTypeAndValue> names = new ArrayList<>();

    /**
     * Instantiates a new Xml psp.
     *
     * @param pspIdType the psp id type
     * @param pspId     the psp id
     */
    public XmlPsp(final String pspIdType, final String pspId, String other) {
        this.pspId = new XmlTypeAndValue(pspIdType, pspId, other);
    }

    /**
     * Add name.
     *
     * @param pspName     the psp name
     * @param pspNameType the psp name type
     */
    public void addName(final String pspName, final String pspNameType, String other) {
        this.names.add(new XmlTypeAndValue(pspName, pspNameType, other));
    }
}
